/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.loot;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.loot.v2.FabricLootTableBuilder;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.impl.loot.LootUtil;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_52;
import net.minecraft.class_60;
import net.minecraft.class_8488;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_60.class})
abstract class LootManagerMixin {
    @Shadow
    private Map<class_8488<?>, ?> field_44492;

    LootManagerMixin() {
    }

    @Inject(method={"reload"}, at={@At(value="RETURN")}, cancellable=true)
    private void reload(class_3302.class_4045 synchronizer, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        class_60 lootManager = (class_60)this;
        cir.setReturnValue((Object)((CompletableFuture)cir.getReturnValue()).thenRun(() -> this.applyLootTableEvents(manager, lootManager)));
    }

    @Unique
    private void applyLootTableEvents(class_3300 resourceManager, class_60 lootManager) {
        ImmutableMap.Builder newTables = ImmutableMap.builder();
        this.field_44492.forEach((dataKey, entry) -> {
            if (dataKey == class_60.field_44491) {
                newTables.put(dataKey, entry);
                return;
            }
            if (!(entry instanceof class_52)) {
                newTables.put(dataKey, entry);
                return;
            }
            class_52 table = (class_52)entry;
            LootTableSource source = LootUtil.determineSource(dataKey.comp_1475(), resourceManager);
            class_52 replacement = ((LootTableEvents.Replace)LootTableEvents.REPLACE.invoker()).replaceLootTable(resourceManager, lootManager, dataKey.comp_1475(), table, source);
            if (replacement != null) {
                table = replacement;
                source = LootTableSource.REPLACED;
            }
            class_52.class_53 builder = FabricLootTableBuilder.copyOf(table);
            ((LootTableEvents.Modify)LootTableEvents.MODIFY.invoker()).modifyLootTable(resourceManager, lootManager, dataKey.comp_1475(), builder, source);
            newTables.put(dataKey, (Object)builder.method_338());
        });
        this.field_44492 = newTables.build();
        ((LootTableEvents.Loaded)LootTableEvents.ALL_LOADED.invoker()).onLootTablesLoaded(resourceManager, lootManager);
    }
}

